unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    columnslabel: TStaticText;
    columnUpDown: TUpDown;
    PaintBox1: TPaintBox;
    resetBtn: TSpeedButton;
    Label2: TLabel;
    pathlabel: TStaticText;
    GoBtn: TSpeedButton;
    msglabel: TLabel;
    stepcheckbox: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure columnUpDownClick(Sender: TObject; Button: TUDBtnType);
    procedure resetBtnClick(Sender: TObject);
    procedure GoBtnClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure stepcheckboxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type Tsquare = record
                col : byte;      //column of square
                row : byte;      //row ..
                dirs : byte;     //allowed entry/exit directions
                                 //1:right; 2:up; 4:left; 8:down
                full : boolean;  //path present
               end;
     TsearchResult = (srStart,srCnt,srOK,srEnd);
     Tstep = record
              pos : byte;        //place of square
              dir : byte;        //direction 1,2,4,8
             end;

var bm : Tbitmap;
    square : array[1..45] of Tsquare; //directions list
    Gwidth : byte = 4;

//-- path finding --

    path : array[1..45] of TStep;
    pathlength : byte;
    pathcount : longword;
    search  : TsearchResult;
    squareA : byte;
    squareB : byte;
    searchBusy : boolean;

procedure paintedges;
//paint line around paintbox
var x1,y1,x2,y2 : word;
begin
 with form1.PaintBox1 do
  begin
   x1 := left-1;
   y1 := top-1;
   x2 := left+width;
   y2 := top+height;
  end;            with form1.Canvas do
  begin
   pen.Width:= 1;
   moveto(x1,y1);
   lineto(x1,y2);
   lineto(x2,y2);
   lineto(x2,y1);
   lineto(x1,y1);
  end;
end;

procedure setDimension;
var r : Trect;
    i : byte;
begin
 with form1 do
  begin
   r := rect(30,40,640,180);
   canvas.brush.color := color;
   canvas.brush.style := bsSolid;
   canvas.fillrect(r);
   Gwidth := columnUpDown.Position;
   bm.Width := Gwidth * 40 + 1;
   paintbox1.Width := bm.Width;
  end;
//
 for i := 1 to 3*Gwidth do
  with square[i] do
   begin
    dirs := 15;
    col := ((i-1) mod Gwidth) + 1;
    row := ((i-1) div Gwidth) + 1;
    full := false;
    if col = 1 then dirs := dirs xor 4
     else if col = Gwidth then dirs := dirs xor 1;
    if row = 1 then dirs := dirs xor 2
     else if row = 3 then dirs := dirs xor 8;
   end;
 squareA := Gwidth + 2;
 squareB := 2*Gwidth - 1;
 square[squareA].dirs := 11;
 square[squareB].dirs := 0;
 square[squareA-1].dirs := 10;
 square[squareA+1].dirs := 11;
 square[squareB+1].dirs := $a;
 pathlength := 3*Gwidth;
 searchbusy := false;
end;

procedure paintBM;
var i : word;
begin
 with bm do with canvas do
  begin
   pen.width := 1;
   pen.Color := 0;
   brush.Color := $f0f0f0;
   fillrect(rect(0,0,width,height));
   i :=0;
   while i < bm.Width do
    begin
     moveto(i,0);
     lineto(i,height);
     inc(i,40);
    end;
   i := 0;
   while i < height do
    begin
     moveto(0,i);
     lineto(width,i);
     inc(i,40);
    end;
   brush.style := bsClear;
   textout(53,50,'A');
   textout(width-67,50,'B');
  end;
end;

procedure showBM;
begin
 form1.paintbox1.canvas.draw(0,0,bm);
end;

procedure clearPath;
var i : byte;
begin
 for i := 1 to 3*Gwidth do
  begin
   with path[i] do
    begin
     pos := 0;
     dir := 0;
    end;
   square[i].full := false;
 end;
 paintBM;
 showBM;
end;

procedure squarecenter(var x,y : word; n : byte);
begin
 x := square[n].col*40 - 20;
 y := square[n].row*40 - 20;
end;

procedure paintPath;
var x,y : word;
    i : byte;
begin
 with bm.Canvas do
  begin
   pen.Width := 3;
   pen.Color := $ff0000;
   squarecenter(x,y,squareA);
   moveto(x,y);
   for i := 2 to pathlength do
    begin
     squarecenter(x,y,path[i].pos);
     lineto(x,y);
    end;
 end;
end;

function findpath(sr : TsearchResult) : Tsearchresult;
label nextstep,teststep,nextdirection,stepBack;
var xdir,nextpos,xpos,step : byte;
begin
 xpos := 0;
 step := 0;
 case sr of
  srStart : begin
             xpos := squareA;
             step := 1;
             path[step].pos := xpos;
             square[xpos].full := true;
             goto nextstep;
            end;
  srCnt   : begin
             step := pathlength;
             Xpos := path[step].pos;
             goto stepBack;
            end;
 end;//case

nextstep:

 xdir := 1;

teststep:

 if (square[xpos].dirs and xdir) = 0 then goto nextdirection;
 case xdir of
  1 : nextpos := xpos + 1;
  2 : nextpos := xpos - Gwidth;
  4 : nextpos := xpos - 1;
  8 : nextpos := xpos + Gwidth;
  else nextpos := 1;
 end;//case
 if square[nextpos].full then goto nextdirection;
 if (nextpos = squareB) and (step < pathlength-1) then goto nextdirection;

//register step

 path[step].dir := xdir;
 inc(step);
 path[step].pos := nextpos;
 xpos := nextpos;
 square[xpos].full := true;
 if (step = pathlength) and (xpos = squareB) then
  begin
   result := srOK;   //found path
   exit;
  end;
 goto nextstep;

nextdirection:

 xdir := xdir shl 1;
 if xdir > 8 then goto stepback;
 goto teststep;

stepback:

 if step = 1 then
  begin
   result := srEnd;  //no path found
   exit;
  end;
 square[xpos].full := false;
 dec(step);
 xpos := path[step].pos;
 xdir := path[step].dir;
 goto nextdirection;
end;

procedure procSearch;
var sr : TsearchResult;
    stepmode : boolean;
begin
 stepmode := form1.stepcheckbox.checked;
 if searchbusy = false then
  begin
   sr := srStart;
   searchbusy := true;
   pathcount := 0;
  end else sr := srCnt;
 repeat
  sr := findPath(sr);
  case sr of
   srOK  : begin      //path found
            inc(pathcount);
            sr := srCnt;
            form1.pathlabel.Caption := inttostr(pathcount);
            if stepmode then
             begin;
              paintBM;
              paintpath;
              showBM;
              form1.msglabel.Caption := 'Path found. Press <SPACE> for next '+
                                        '<ESCAPE> to stop';
             end;
           end;
   srEnd : begin     //all paths found
            if pathcount = 0 then form1.msglabel.Caption := 'No path found.'
             else form1.msglabel.caption := 'Done';
            searchbusy := false;
           end;
  end;//case
 until (stepmode) or (sr = srEnd);
end;

procedure TForm1.GoBtnClick(Sender: TObject);
begin
 if searchBusy = false then procSearch;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 bm := Tbitmap.Create;
 bm.Height := 121;
 bm.PixelFormat := pf32bit;
 bm.canvas.font.name := 'arial';
 bm.canvas.font.height := 24;
 setDimension;
 paintBM;
 search := srStart;
 msglabel.Caption := 'welcome to the pathfinder';
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 bm.Free;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 paintedges;
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
 showBM;
end;

procedure TForm1.columnUpDownClick(Sender: TObject; Button: TUDBtnType);
begin
 setDimension;
 paintedges;
 paintBM;
 showBM;
 pathlabel.Caption := '';
end;

procedure TForm1.resetBtnClick(Sender: TObject);
begin
 pathlabel.Caption := '';
 msglabel.Caption := '';
 clearPath;
 searchbusy := false;
 paintBM;
 showBM;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 case key of
  VK_SPACE  : if searchbusy then procSearch;
  VK_ESCAPE : resetBtnClick(self);
 end;//case
end;

procedure TForm1.stepcheckboxClick(Sender: TObject);
begin
 activecontrol := nil;
end;

end.
