unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    clearBtn: TSpeedButton;
    goBtn: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Label1: TLabel;
    msglabel: TLabel;
    Label2: TLabel;
    procedure clearBtnClick(Sender: TObject);
    procedure goBtnClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const columns = 8;
      Pcount = 5000;  //good points maximum

var rowcount : byte = 2;
    GoodPoints : array[1..Pcount,1..5] of byte;
    GPX : word;                         //GoodPoints index
    counter : array[1..5] of byte;

procedure clearProc;
var i : word;
    j : byte;
begin
 for i:= 1 to Pcount do
  for j := 1 to 5 do GoodPoints[i,j] := 0;
 for i := 1 to 5 do counter[i] := 0;
 form1.Memo1.Clear;
 GPX := 0;
end;

function CounterInc : boolean;
var carry,i : byte;
begin
 carry := 1;
 for i := 1 to rowcount do
  begin
   counter[i] := counter[i] + carry;
   if counter[i] < columns then carry := 0 else counter[i] := 0;
  end ;
 result := carry = 0;
end;

procedure reportPoint;
var s : string;
    i : byte;
begin
 s := '';
 for i := 1 to rowcount do
  begin
   s := s + '  ' + chr(ord('0') + counter[i]);
  end;
 form1.memo1.lines.Add(s);
end;

procedure SavePoint;
var i : byte;
begin
 inc(GPX);
 for i:= 1 to rowcount do GoodPoints[GPX,i] := counter[i];
 reportPoint;
end;

procedure TestPoint;
var i : word;
    d,j : byte;
begin
 i := 0;
 repeat
  inc(i);
  j := 0;
  d := 0;
  repeat
   inc(j);
   if counter[j] <> GoodPoints[i,j] then inc(d);
  until j=rowcount;
 until (d=1) or (i=GPX);
 if d <> 1 then savePoint;
end;

procedure TForm1.GoBtnClick(Sender: TObject);
begin
 msglabel.caption := 'running...';
 application.processmessages;
 clearProc;
 savepoint;
 while counterInc do testPoint;
 msglabel.Caption := 'End. GPcount = '+inttostr(GPX);
end;

procedure TForm1.clearBtnClick(Sender: TObject);
begin
 ClearProc;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
 rowcount := TSpeedbutton(sender).Tag;
end;

end.
